/******************************************/
/* Small On-line Ramsey Numbers for Paths */
/* Author: Pawel Pralat                   */
/******************************************/
/* Is R(P_m,P_l) equal to k ?             */
/******************************************/

#include <stdio.h>
#include <time.h>

int ver, m, k, l, n, nr_vertices, color, length; 
int nr_edges[3];
char v[20][20];                          // number of nodes MUST be smaller than 20
char visited[20];
int nr;

int bfs2(int d1, int v2, int d2)
{
  if (d1+d2>=length) 
    return 0;
  
  int i;
  for (i=0 ; i<nr_vertices ; i++)
    if (v[v2][i]==color)
      if (visited[i]==0)
      {
        visited[i]=1;
        if (bfs2(d1, i, d2+1))
	  visited[i]=0;
	else 
	  {
	    visited[i]=0;
	    return 0;
	  }
      }
  return 1;
}

int bfs(int v1, int d1, int v2)
{
  if (!(bfs2(d1, v2, 0)))
    return 0;

  int i;
  for (i=0 ; i<nr_vertices ; i++)
    if (v[v1][i]==color)
      if (visited[i]==0) 
      {
	visited[i]=1;
	if (bfs(i, d1+1, v2))
	  visited[i]=0;
	else
	  {
	    visited[i]=0;
	    return 0;
	  }
      }
  return 1;
}

int add()
{
  int condition = nr_edges[1]+nr_edges[2];
  if (m-2-nr_edges[1] > 0) condition += m-2-nr_edges[1];
  if (l-2-nr_edges[2] > 0) condition += l-2-nr_edges[2];
  if (condition >= k) return 0;

  int i, j, c1, c2;

  // new edge between existing nodes
  for (i=0 ; i<nr_vertices-1 ; i++)
    for (j=i+1 ; j<nr_vertices ;j++) 
      if (!v[i][j])          // the builder draws edge {i,j}
	{
	  visited[i]=visited[j]=1;
	  color=1; length=m-1;
	  if (bfs(i,1,j))
	    {
	      visited[i]=visited[j]=0;
	      v[j][i]=v[i][j]=1;
	
	      nr_edges[1]++;
	      c1=add();
	      nr_edges[1]--;
	    }
	  else
	    c1=1;

	  if (c1)
	    {
	      visited[i]=visited[j]=1;
	      color=2; length=l-1;
	      if (bfs(i,1,j))
		{
		  visited[i]=visited[j]=0;
		  v[j][i]=v[i][j]=2;

		  nr_edges[2]++;
		  c2=add();
		  nr_edges[2]--;
		}
	      else
		c2=1;
	    }
	  
	  v[j][i]=v[i][j]=0;
	  visited[i]=visited[j]=0;
	  if (c1 && c2)
	    return 1;
	}

  // new edge between existing node and a new one
  if (nr_vertices < n)
    for (i=0 ; i<nr_vertices ; i++) // the builder draws edge {i,nr_vertices}
      {
	j = nr_vertices;
	visited[i]=visited[j]=1;
	color=1; length=m-1;
	if (bfs(i,1,j))
	  {
	    visited[i]=visited[j]=0;
	    v[j][i]=v[i][j]=1;
	    
	    nr_vertices++; nr_edges[1]++;
	    c1=add();
	    nr_edges[1]--; nr_vertices--;
	  }
	else
	  c1=1;
	
	if (c1)
	  {
	    visited[i]=visited[j]=1;
	    color=2; length=l-1;
	    if (bfs(i,1,j))
	      {
		visited[i]=visited[j]=0;
		v[j][i]=v[i][j]=2;

		nr_vertices++; nr_edges[2]++;
		c2=add();
		nr_edges[2]--; nr_vertices--;
	      }
	    else
	      c2=1;
	  }
	
	v[j][i]=v[i][j]=0;
	visited[i]=visited[j]=0;
	if (c1 && c2)
            return 1;
      }

  // new edge between new nodes
  if (nr_vertices < n-1)
    {
      i = nr_vertices;                   // the builder draws edge {nr_vertices,nr_vertices+1}
      j = nr_vertices+1;
      v[j][i]=v[i][j]=1;
	  
      nr_vertices+=2; nr_edges[1]++;
      c1=add();
      nr_edges[1]--; nr_vertices-=2;
      
      if (c1)
	{
	  v[j][i]=v[i][j]=2;

	  nr_edges[2]++; nr_vertices+=2;
	  c2=add();
	  nr_edges[2]--; nr_vertices-=2;
	}
      
      v[j][i]=v[i][j]=0;
      if (c1 && c2)
	return 1;
    }

  return 0;
}

main(int argc, char * argv[])
{
  if (argc != 8)
    {
      printf("Is R(P_m,P_l) equal to k ?\n");
      printf("Usage: ramsey <m> <l> <k> <n> <number of the initial graph, 1-?> <input file name> <output file name>\n\n");
      return 0;
    }

  time_t time_begin = time(NULL);

  m = atol(argv[1]);
  l = atol(argv[2]);
  k = atol(argv[3]);		
  n = atol(argv[4]);
  ver = atol(argv[5]);
  int i,a,b,c;
  nr_edges[1]=nr_edges[2]=0;

  FILE * in = fopen(argv[6], "rt");
  FILE * out;
  int result;
  int flag = 1;

  while (flag)
    {
      int tmp;
      fscanf(in, "%d m=%d n=%d ", &tmp, &nr, &nr_vertices);
      
      if (tmp == ver)
	{
	  flag = 0;
	  for (i=0 ; i<nr ; i++)
	    {
	      fscanf(in, "%d,%d,%d ", &a, &b, &c);
	      nr_edges[c]++;
	      v[a][b] = c;
	      v[b][a] = c;

	      // graph could be illegal, that is, could contain red P_m or blue R_l
	      visited[a]=visited[b]=1;
	      color=c; 
	      if (color==1) length=m-1;
	      else length=l-1;

	      if (!bfs(a,1,b))
		{
		  fclose(in);
		  out = fopen(argv[7],"w");

		  fprintf(out, "%d %d : ILLEGAL\n", nr, ver);
		  fclose (out);
		  return 0;
		}
	      visited[a]=visited[b]=0;
	    }
	}
      else
	{
          for (i=0 ; i<nr ; i++)
	    fscanf(in, "%d,%d,%d ", &a, &b, &c);
	}
      
      fscanf(in, "\n");
    }

  fclose(in);

  // number of nodes could be illegal
  if (nr_vertices > n)
    {
      out = fopen(argv[7],"w");

      fprintf(out, "1000 %d : ILLEGAL (NO)\n", ver);
      fclose (out);
      return 0;
    }

  result = add();
    if (result)
    {
      out = fopen(argv[7],"w");
      fprintf(out, "%d %d : OK ", k, ver);
    }
  else
    {
      out = fopen(argv[7],"w");
      fprintf(out, "%d %d : NO ", k, ver);
    }

  time_t time_end = (time(NULL) - time_begin);
  float how_long = time_end / 3600.0;

  fprintf(out,"%f \n", how_long);
  fclose(out);

  return 0;
}
