/******************************************/
/* Small On-line Ramsey Numbers for Paths */
/* Author: Pawel Pralat                   */
/******************************************/
/* Generating paths on m edges            */       
/******************************************/


#include <stdio.h>

const int m = 10;                    // number of edges
int global;                         // global variable
FILE * out;

void **** graphs;

class graph;

class node2
{
public:
  graph * g1;
  graph * g2;
  node2 * next;
};

class graph
{
public:
  int n;             // number of nodes
  int m;             // number of edges
  int m1;            // number of edges in the first colour (1)
  int * g;           // matrix
  int * deg;         // degree sequence
  int * order;       // degree sequence order (increasing)
  node2 * list;      // decision tree
  int v;             // ninimal number of moves needed to force the paiter to draw a path

  ~graph()
  {
    delete [] g;
    delete [] deg;
    delete [] order;

    node2 * tmp;
    while (list != NULL)
      {
	tmp = list;
	list = list->next;
	delete tmp;
      }
  }

  graph()            // graph with one edge
  {
    n = 2;
    m = m1 = 1;
    g = new int [n*n];
    deg = new int [n];
    order = new int [n];
    g[0] = g[3] = 0;
    g[1] = g[2] = 1;
    deg[0] = deg[1] = 1;
    order[0] = 0;
    order[1] = 1;
    list = NULL;
    v = -1;
  }

  graph(graph * gr, int a, int b, int c)
  {
    v = -1;
    n = gr->n;
    int old_n = n;
    int i,j;
    if (a >= n) n = a+1;
    if (b >= n) n = b+1;
    m = gr->m + 1;
    m1 = gr->m1;
    if (c == 1) m1++;
    list = NULL;

    g = new int [n*n];
    deg = new int [n];
    order = new int [n];

    for (i = 0 ; i < old_n ; i++)
      for (j = 0 ; j < old_n ; j++)
	g[i*n+j] = gr->g[i*old_n+j];
    
    for (i = old_n ; i < n ; i++)
      for (j = 0 ; j < n ; j++)
	g[i*n+j] = 0;

    for (j = old_n ; j < n ; j++)
      for (i = 0 ; i < n ; i++)
	g[i*n+j] = 0;

    g[a*n+b] = g[b*n+a] = c;

    // change colours if the number of edges in the 1st colour is smaller than 
    // the number of edges in the 2nd colour
    if (m1 < m-m1)
      {
	for (i = 0 ; i < n ; i++)
	  for (j = 0 ; j < n ; j++)
	    if (g[i*n+j] == 1)
	      g[i*n+j] = 2;
	    else if (g[i*n+j] == 2)
	      g[i*n+j] = 1;

	m1 = m-m1;
      }

    // create a degree sequence
    for (i = 0 ; i < n ; i++)
      {
	int c[3];
	c[1] = c[2] = 0;
	for (j = 0 ; j < n ; j++)
	  c[g[i*n+j]]++;
	deg[i] = c[1]*(m-m1+1)+c[2];
      }

    // degree sequence sorting (insertsort)
    order[0] = 0;
    for (i = 1 ; i < n ; i++)
      {
	j = i; 
	while ((j > 0) && (deg[i] < deg[order[j-1]]))
	  {
	    order[j] = order[j-1];
	    j--;
	  }
	order[j] = i;
      }
  }

  void inverse()
  {
    int i,j;
    for (i = 0 ; i < n ; i++)
      for (j = 0 ; j < n ; j++)
	if (g[i*n+j] == 1)
	  g[i*n+j] = 2;
	else if (g[i*n+j] == 2)
	  g[i*n+j] = 1;
    
    m1 = m - m1;

    // create a degree sequence
    for (i = 0 ; i < n ; i++)
      {
        int c[3];
        c[1] = c[2] = 0;
        for (j = 0 ; j < n ; j++)
          c[g[i*n+j]]++;
        deg[i] = c[1]*(m-m1+1)+c[2];
      }

    // degree sequence sorting (insertsort)
    order[0] = 0;
    for (i = 1 ; i < n ; i++)
      {
        j = i;
        while ((j > 0) && (deg[i] < deg[order[j-1]]))
          {
            order[j] = order[j-1];
            j--;
          }
        order[j] = i;
      }
  }

  void info()
  {
    printf("%d m=%d m1=%d n=%d e=", global, m, m1, n);
    int i,j;
    for (i = 0 ; i < n ; i++)
      for (j = i+1 ; j < n ; j++)
	if (g[i*n+j])
	  printf("%d,%d,%d ", i, j, g[i*n+j]);
    if (v != -1)
      printf("VALUE=%d", v);
    printf("\n");
  }

  void info_f()
  {
    fprintf(out, "%d m=%d n=%d ", global, m, n);
    int i,j;
    for (i = 0 ; i < n ; i++)
      for (j = i+1 ; j < n ; j++)
        if (g[i*n+j])
          fprintf(out, "%d,%d,%d ", i, j, g[i*n+j]);
    if (v != -1)
      fprintf(out, "VALUE=%d", v);
    fprintf(out, "\n");
  }

  void next_level();
};

class node
{
public:
  graph * g;
  node * next;
};

int compare(graph * g, graph *f, int * b, int i)
{
  int j;
  int n = g->n;

  for (j = 0 ; j < n ; j++)
    if ((b[j] != -1) && (g->g[i*n+j] != f->g[b[i]*n+b[j]]))
      return 0;
  return 1;
}

int compare(graph * g, graph * f, int * b, int * perm, int first, int last, int missing) 
{

  int i, tmp;
  int n = g->n;

  if (first > last) 
    {
      if (missing == 0)
	return 1;
      else
	{
	  for (i = 0 ; i < n-1 ; i++)
	    if ((b[g->order[i]] == -1) && (g->deg[g->order[i]] == g->deg[g->order[i+1]]))
	      {
		first = i;
		i++;
		while ((i < n-1) && ((g->deg[g->order[i]] == g->deg[g->order[i+1]])))
		  i++;
		last = i;
		
		return compare(g,f,b,perm,first,last,missing);
	      }
	}
    }

  for (i = first ; i <= last ; i++)
    {
      b[g->order[first]] = f->order[perm[i]];
      if (compare(g,f,b,g->order[first]) == 0)
	b[g->order[first]] = -1;
      else
	{
	  tmp = perm[first];
	  perm[first] = perm[i];
	  perm[i] = tmp;

	  if (compare(g,f,b,perm,first+1,last, missing-1) == 1)
	    return 1;

	  perm[i] = perm[first];
	  perm[first] = tmp;
	  b[g->order[first]] = -1;
	}
    }

  return 0;
}

int compare(graph * g, graph * f)
  // results: 1 - graphs are the same
  //          0 - otherwise
{
  int i;
  int n = g->n;
  int missing = 0;

  // bijection: vertex i in G corresponds to vertex b[i] in F
  int * b = new int [n];
  for (i = 0 ; i < n ; i++)
    b[i] = -1;

  for (i = 0 ; i < n-1 ; )
    if (g->deg[g->order[i]] != g->deg[g->order[i+1]])
      {
	b[g->order[i]] = f->order[i];
	if (compare(g,f,b,g->order[i]) == 0)
	  {
	    delete [] b;
	    return 0;
	  }
	i++;
      }
    else
      {
	missing+=2;
	i+=2;
	while ((i < n) && ((g->deg[g->order[i]] == g->deg[g->order[i-1]])))
	  {
	    i++;
	    missing++;
	  }
      }
  
  if (g->deg[g->order[n-2]] != g->deg[g->order[n-1]])
    {
      b[g->order[n-1]] = f->order[n-1];
      if (compare(g,f,b,g->order[n-1]) == 0)
	{
	  delete [] b;
	  return 0;
	}
    }

  if (missing > 0)
    {
      int first,last;
      int * perm = new int [n];
      for (i = 0 ; i < n ; i++)
	perm[i] = i;
      
      for (i = 0 ; i < n-1 ; i++)
	if (g->deg[g->order[i]] == g->deg[g->order[i+1]])
	  {
	    first = i;
	    i++;
	    while ((i < n-1) && ((g->deg[g->order[i]] == g->deg[g->order[i+1]])))
	      i++;
	    last = i;
	   
	    int result = compare(g,f,b,perm,first,last, missing);

	    delete [] b;
	    delete [] perm;
	    
	    return result;
	  }
    }
  
  delete [] b;

  return 1;
}

graph * check(graph * gr)
  // result:
  // != NULL : graph *gr is on the list. 
  //           as the result we have a pointer to this graph (on the list)
  // NULL : otherwise
{
  int i,j;
  void ** p = & graphs[gr->m][gr->m1][gr->n];
  for (i = 0 ; i < gr->n ; i++)
    {
      if (*p == NULL)
	return NULL;
      p = ((void **) (*p)) + gr->deg[gr->order[i]];
    }

  node * list = (node *) *p;
  while (list != NULL)
    {
      if (compare(gr,list->g))
	  return list->g;
      list = list->next;
    }
  return NULL;
}

void add(graph * gr)
  // we assume that graph *gr is NOT on the list
{
  int i,j;
  void ** p = & graphs[gr->m][gr->m1][gr->n];
  for (i = 0 ; i < gr->n ; i++)
    {
      if (*p == NULL) 
	{
	  void ** tmp = new void * [(1+gr->m1)*(1+gr->m-gr->m1)];
          for (j = 0 ; j < (1+gr->m1)*(1+gr->m-gr->m1) ; j++)
            tmp[j] = NULL;
	  *p = (void *) tmp;
	}
      p = ((void **) (*p)) + gr->deg[gr->order[i]];
    }
  
  node * new_node = new node;
  new_node->g = gr;
  new_node->next = (node *) *p;
  *p = (void *) new_node;
}

void next_move(graph * g, int i, int j)
{
  graph * first_r;
  graph * second_r;
  graph * first_c;
  graph * second_c;

  first_c = new graph(g, i, j, 1);
  second_c = new graph(g, i, j, 2);

  first_r = check(first_c);

  if ((first_c->m1 == first_c->m - first_c->m1) && (first_r == NULL))
    {
      first_c->inverse();
      first_r = check(first_c);
    }
  if (first_r == NULL)
    {
      add (first_c);
      first_r = first_c;
    }
  else
    delete first_c;

  second_r = check(second_c);
  if ((second_c->m1 == second_c->m - second_c->m1) && (second_r == NULL))
    {
      second_c->inverse();
      second_r = check(second_c);
    }
  if (second_r == NULL)
    {
      add (second_c);
      second_r = second_c;
    }
  else
    delete second_c;

  // we assume that the first graph is always first in the memory
  if (first_r > second_r)
    {
      first_c = first_r;        // temporary pointer
      first_r = second_r;
      second_r = first_c;
    }

  // check if this pair is on the list or not
  node2 * ptr = g->list;
  while ((ptr != NULL) && ( (ptr->g1 != first_r) || (ptr->g2 != second_r) )) 
    ptr = ptr->next;

  if (ptr == NULL)             // new pair
    {
      node2 * new_node = new node2;
      new_node->next = g->list;
      new_node->g1 = first_r;
      new_node->g2 = second_r;
      g->list = new_node;
    }
}


void graph::next_level()
{
  int i,j;
/*
  for (i = 0 ; i < n ; i++)
    for (j = i+1 ; j < n ; j++)
      if (g[i*n+j] == 0)
	next_move(this,i,j);
*/
  for (i = 0 ; i < n ; i++)
    if ((deg[i]==1) || (deg[i]==(m-m1+1)))
      next_move(this, i, n);

//  next_move(this, n, n+1);
}

void do_something(void * p, int s, int l, int n, int task)
{
  if (l == n)
    {
      node * ptr = (node *) p;
      while (ptr)
	{
	  if (task == 1)
	    {
	      global++;
	      ptr->g->info();
	      ptr = ptr->next;
	    }
	  else if (task == 2)
	    {
	      ptr->g->next_level();
	      ptr = ptr->next;
	    }
	  else if (task == 3)
	    {
	      delete ptr->g;
	      node * tmp = ptr;
	      ptr = ptr->next;
	      delete tmp;
	    }
	  else if (task == 4)
            {
              global++;
              ptr->g->info_f();
              ptr = ptr->next;
            }
	  else if (task == 5)
	    {
	      global++;
	      char file_name [15];
	      sprintf(file_name, "%d.res", global);
	      out = fopen(file_name, "rt");
	      fscanf(out, "%d ", &ptr->g->v);
	      ptr = ptr->next;
	      fclose(out);
	    }
	  else if (task == 6)
	    {
	      node2 * list = ptr->g->list;

	      int min_v;
	      int v1, v2;

	      v1 = list->g1->v;
	      v2 = list->g2->v;

	      if (v1 > v2)
		min_v = v1;
	      else
		min_v = v2;

	      list = list->next;

	      while (list)
		{
		  v1 = list->g1->v;
		  v2 = list->g2->v;

		  if (v1 > v2)
		    {
		      if (min_v > v1)
			min_v = v1;
		    }
		  else
		    {
		      if (min_v > v2)
			min_v = v2;
		    }

		  list = list->next;
		} 
	      ptr->g->v = min_v;
	      ptr = ptr->next;
	    }
	}
      return;
    }

  void ** ptr = (void **) p;
  int i;
  for (i = 0 ; i < s ; i++)
    if (ptr[i] != NULL)
      do_something(ptr[i], s, l+1, n, task);
  
  if (task == 3)
    delete [] ptr;
}

void do_something(int m, int task)
  // task = 1 : print information about all graphs with m edges
  // task = 2 : generate next level (m+1) from all graphs with m edges
  // task = 3 : free memory
  // task = 4 : store information about all graphs with m edges
  // task = 5 : reading the results from files
  // task = 6 : calculate the values on the smaller levels
{
  int i,j;
  global = 0;
  for (i = m/2 ; i <= m ; i++)
    for (j = 2 ; j <= 2*m ; j++)
      if (graphs[m][i][j] != NULL)
	do_something(graphs[m][i][j], (1+i)*(1+m-i), 0, j, task);
}

int main()
{
  int i,j,k;

  graphs = new void *** [m+1];
  for (i = 1 ; i <= m ; i++)
    {
      graphs[i] = new void ** [i+1];
      for (j = i/2 ; j <= i ; j++)
	{
	  graphs[i][j] = new void * [2*i+1];
	  for (k = 2 ; k <= 2*i ; k++)
	    graphs[i][j][k] = NULL;
	}
    }

  graph * first = new graph;
  add (first);

  // create next levels
  for (i = 1 ; i < m ; i++)
    do_something(i,2);

  // print all graphs
  //for (i = 1 ; i <= m ; i++)
  //  {
  //    printf("level %d : \n", i);
  //    do_something(i,1);
  //  }

  // store all graphs on the last level
  out = fopen("input.txt", "wt");
  do_something(m,4);
  fclose(out);

  out = fopen("1.res", "rt");
  if (out != NULL)                   // we are ready for merging
    {
      fclose(out);
      do_something(m,5);             // reading the results from files

      for (i=m-1 ; i>=1 ; i--)
	do_something(i,6);           // calculate the values on the previous levels

      out = fopen("output.txt", "wt");
      for (i = 1 ; i<=m ; i++)
	{
	  fprintf(out, "level %d : \n", i);
	  do_something(i,4);
	}
    }

  // free memory
  for (i = 1 ; i <= m ; i++)
    do_something(i,3);

  return 0;
}
